#include "game.h"

void IWRAM_CODE DrawLine(int x1, int y1, int x2, int y2, u8 color)
{
	int i;
	int deltax;
	int deltay;
	int numpixels;
	int d;
	int dinc1;
	int dinc2;
	int xinc1;
	int xinc2;
	int yinc1;
	int yinc2;

	if((x1 < 0 && x2 < 0)||(y1 < 0 && y2 < 0)||(x1 > 239 && x2 > 239)||(y1 > 159 && y2 > 159)) return;

	if(x1>=0 && y1 >= 0 && x1 < 240 && y1 < 160) DrawPixelToBuffer(x1, y1, color, BackBuffer);
	if(x2>=0 && y2 >= 0 && x2 < 240 && y2 < 160) DrawPixelToBuffer(x2, y2, color, BackBuffer);

	deltax = abs(x2 - x1);
	deltay = abs(y2 - y1);

	if(deltax >= deltay)
	{
		numpixels = deltax + 1;
		d = (deltay<<1) - deltax;
		dinc1 = deltay << 1;
		dinc2 = (deltay - deltax) << 1;
		xinc1 = 1;
		xinc2 = 1;
		yinc1 = 0;
		yinc2 = 1;
	}
	else
	{
		numpixels = deltay + 1;
		d = (deltax<<1) - deltay;
		dinc1 = deltax << 1;
		dinc2 = (deltax - deltay) << 1;
		xinc1 = 0;
		xinc2 = 1;
		yinc1 = 1;
		yinc2 = 1;
	}

	if(x1 > x2)
	{
		xinc1 = -xinc1;
		xinc2 = -xinc2;
	}
	if(y1 > y2)
	{
		yinc1 = -yinc1;
		yinc2 = -yinc2;
	}

	for(i = 1; i < numpixels; i++)
	{
		if(x1>=0 && y1 >= 0 && x1 < 240 && y1 < 160) DrawPixelToBuffer(x1, y1, color, BackBuffer);

		if(d < 0)
		{
			d += dinc1;
			x1 += xinc1;
			y1 += yinc1;
		}
		else
		{
			d += dinc2;
			x1 += xinc2;
			y1 += yinc2;
		}
	}
}
